@extends('layouts.admin')

@section('content')
    <!-- Page Header -->
    <div class="py-6 bg-[#F6F6F6] border-b border-[#CBB4B0]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Generate Kredensial Pasien</h1>
                    <p class="text-gray-600 mt-1">Buat MRN dan password untuk {{ $patient->name }}</p>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.patient-management.index') }}" 
                       class="bg-[#8B8B8B] text-white px-4 py-2 rounded-none hover:bg-[#192D50] transition duration-150">
                        Kembali
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 bg-[#F6F6F6]">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Patient Info -->
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none mb-8 border border-[#CBB4B0]">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Pasien</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <p class="text-sm text-gray-600">Nama:</p>
                            <p class="font-medium text-gray-900">{{ $patient->name }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Email:</p>
                            <p class="font-medium text-gray-900">{{ $patient->email }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Telepon:</p>
                            <p class="font-medium text-gray-900">{{ $patient->phone }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">KTP:</p>
                            <p class="font-medium text-gray-900">{{ $patient->ktp_number }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Credentials Form -->
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-6">Generate Kredensial</h3>
                    
                    <form method="POST" action="{{ route('admin.patient-management.generate-credentials', $patient) }}" class="space-y-6">
                        @csrf
                        
                        <div>
                            <label for="mrn" class="block text-sm font-medium text-gray-700 mb-2">
                                No. Rekam Medis (MRN) <span class="text-green-600">(Auto-Generated)</span>
                            </label>
                            <div class="flex items-center space-x-2">
                                <input type="text" id="mrn" name="mrn" 
                                       class="flex-1 px-4 py-3 border border-gray-300 rounded-none bg-gray-50 text-gray-700"
                                       value="{{ \App\Models\Patient::generateMRN() }}" readonly>
                                <button type="button" id="regenerate-mrn" 
                                        class="px-3 py-2 bg-[#192D50] text-white text-sm rounded-none hover:bg-[#8B8B8B] transition duration-150">
                                    Regenerate
                                </button>
                            </div>
                            <p class="text-sm text-gray-500 mt-1">
                                MRN akan di-generate otomatis. Klik "Regenerate" untuk membuat MRN baru.
                            </p>
                            @error('mrn')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="password" class="block text-sm font-medium text-gray-700 mb-2">
                                Password
                            </label>
                            <input type="text" id="password" name="password" 
                                       class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]"
                                   placeholder="Kosongkan untuk auto-generate password"
                                   value="{{ old('password') }}">
                            <p class="text-sm text-gray-500 mt-1">
                                Biarkan kosong untuk auto-generate password, atau masukkan password custom
                            </p>
                            @error('password')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="bg-[#192D50] border border-[#CBB4B0] rounded-none p-4">
                            <h4 class="font-medium text-white mb-2">Informasi Penting:</h4>
                            <ul class="text-sm text-white space-y-1">
                                <li>• MRN dan password akan dikirim via email ke {{ $patient->email }}</li>
                                <li>• Pasien dapat menggunakan kredensial ini untuk akses Portal Pasien</li>
                                <li>• Pastikan email pasien valid dan dapat diakses</li>
                                <li>• Kredensial dapat direset nanti jika diperlukan</li>
                            </ul>
                        </div>

                        <div class="flex items-center justify-end space-x-4">
                            <a href="{{ route('admin.patient-management.index') }}" 
                               class="px-4 py-2 border border-[#8B8B8B] rounded-none text-sm font-medium text-[#8B8B8B] hover:bg-[#8B8B8B] hover:text-white transition duration-150">
                                Batal
                            </a>
                            <button type="submit" 
                                    class="px-6 py-2 bg-[#192D50] text-white rounded-none text-sm font-medium hover:bg-[#8B8B8B] transition duration-150">
                                Generate Kredensial
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

<script>
document.addEventListener('DOMContentLoaded', function() {
    const regenerateBtn = document.getElementById('regenerate-mrn');
    const mrnInput = document.getElementById('mrn');
    
    if (regenerateBtn && mrnInput) {
        regenerateBtn.addEventListener('click', function() {
            // Show loading state
            regenerateBtn.innerHTML = 'Generating...';
            regenerateBtn.disabled = true;
            
            // Make AJAX request to get new MRN
            fetch('{{ route("admin.patient-management.regenerate-mrn", $patient) }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    mrnInput.value = data.mrn;
                    // Show success message
                    showMessage('MRN berhasil di-regenerate!', 'success');
                } else {
                    showMessage('Gagal regenerate MRN: ' + data.message, 'error');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showMessage('Terjadi kesalahan saat regenerate MRN', 'error');
            })
            .finally(() => {
                // Reset button
                regenerateBtn.innerHTML = 'Regenerate';
                regenerateBtn.disabled = false;
            });
        });
    }
    
    function showMessage(message, type) {
        // Create message element
        const messageDiv = document.createElement('div');
        messageDiv.className = `fixed top-4 right-4 px-4 py-2 rounded-none text-white z-50 ${
            type === 'success' ? 'bg-green-500' : 'bg-red-500'
        }`;
        messageDiv.textContent = message;
        
        document.body.appendChild(messageDiv);
        
        // Remove after 3 seconds
        setTimeout(() => {
            messageDiv.remove();
        }, 3000);
    }
});
</script>
